<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lector de Código QR</title>
    <script src="https://unpkg.com/html5-qrcode"></script>
    <script src="https://mozilla.github.io/pdf.js/build/pdf.js"></script>
    <script src="https://unpkg.com/jsqr/dist/jsQR.js"></script>
    <style>
        body { font-family: Arial, sans-serif; text-align: center; }
        #reader { width: 300px; margin: auto; }
        #result { margin-top: 20px; font-size: 20px; font-weight: bold; }
        canvas { display: none; } /* Ocultamos el canvas que se usa para analizar el PDF */
    </style>
</head>
<body>

    <h2>Escanea un Código QR</h2>
    
    <!-- Cámara para escaneo en vivo -->
    <div id="reader"></div>

    <!-- Subir PDF -->
    <h3>O selecciona un PDF:</h3>
    <input type="file" id="pdfInput" accept="application/pdf">
    <p id="pdfResult">Esperando archivo...</p>

    <!-- Canvas oculto para extraer imágenes del PDF -->
    <canvas id="pdfCanvas"></canvas>

    <script>
        // 📌 Función para escanear QR desde la cámara
        function onScanSuccess(decodedText, decodedResult) {
            document.getElementById("result").innerHTML = "Código detectado: " + decodedText;
            
            // Enviar el código a PHP (opcional)
            fetch("procesar.php", {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: "codigo=" + encodeURIComponent(decodedText)
            }).then(response => response.text()).then(data => {
                console.log("Respuesta del servidor:", data);
            });
        }

        let scanner = new Html5QrcodeScanner("reader", { fps: 10, qrbox: 250 });
        scanner.render(onScanSuccess);

        // 📌 Función para leer QR de un PDF
        document.getElementById("pdfInput").addEventListener("change", function (event) {
            const file = event.target.files[0];
            if (!file) return;

            const reader = new FileReader();
            reader.onload = function () {
                const typedArray = new Uint8Array(this.result);
                pdfjsLib.getDocument(typedArray).promise.then(pdf => {
                    pdf.getPage(1).then(page => { // Analiza solo la primera página
                        const scale = 2;
                        const viewport = page.getViewport({ scale });

                        const canvas = document.getElementById("pdfCanvas");
                        const context = canvas.getContext("2d");
                        canvas.width = viewport.width;
                        canvas.height = viewport.height;

                        const renderContext = { canvasContext: context, viewport: viewport };
                        page.render(renderContext).promise.then(() => {
                            // Convertir imagen en código QR
                            const imageData = context.getImageData(0, 0, canvas.width, canvas.height);
                            const qrCode = jsQR(imageData.data, canvas.width, canvas.height);
                            if (qrCode) {
                                document.getElementById("pdfResult").innerHTML = "Código en PDF: " + qrCode.data;

                                // Enviar el código a PHP (opcional)
                                fetch("procesar.php", {
                                    method: "POST",
                                    headers: { "Content-Type": "application/x-www-form-urlencoded" },
                                    body: "codigo=" + encodeURIComponent(qrCode.data)
                                }).then(response => response.text()).then(data => {
                                    console.log("Respuesta del servidor:", data);
                                });

                            } else {
                                document.getElementById("pdfResult").innerHTML = "No se encontró código QR en el PDF.";
                            }
                        });
                    });
                });
            };
            reader.readAsArrayBuffer(file);
        });
    </script>

</body>
</html>
